float4x4 matWorldViewProjection;  
float4x4 matView;

float4 color; 
float2 texelsize; 
float time;
float ROCKET[64];

texture tex0;

void vs_prop(in float4 ipos : POSITION, 
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	opos.x -= texelsize.x/2.f;
	opos.y -= texelsize.y/2.f;
	otex = itex;
	otex.y = .5+ipos.z/12;
	//otex.y = (ipos.x+10)/2.f;
};

float4 ps_color(in float2 tex : TEXCOORD0) : COLOR0
{ 
	return color;	
}

float4 ps_paint_pattern(in float2 tex : TEXCOORD0)  : COLOR0
{
	tex = (1-tex)*2.f; //f koordsa fra -1 til 1
	
	//return float4(0, tex.y, 0.f, 0.f);
	
	
	float len = length(1-tex); //yo!
	float pitch = 50.f*sin(len*3.145*20.f);
	return saturate(pitch)*.75; 
}

////////////////////////////////////////////////////////////////////////////////////

void vs_instance(in float4 ipos : POSITION,
				 in float3 inorm : NORMAL,
				 in float2 itex : TEXCOORD0,
				 in float4 world : TEXCOORD1,
				 in float4 shading : TEXCOORD2,
				 
				 out float4 opos : POSITION,
				 out float4 look : TEXCOORD0,
				 out float3  gradient : TEXCOORD1) 
{
	//make texcoord before fuckin'em up
	look.xy	= itex.xy;
	look.y = .5+ipos.z/12;
	
	look.z = 3*(2+shading.x);
	look.w = shading.y;
	
	gradient.x = (1.8f+shading.z)*1.5f;
	
	//shade by normal
	float3 LightPos = float3(20.f, 100.f, 40.f);
	float3 LightDir = normalize(LightPos - mul(abs(ipos), matView));
	gradient.y =  (dot(abs(inorm), normalize(LightDir)));
		
		
	//scale
	//itex = itex*2 - 1;
	shading.w += .2f; //epsilon
	float rx = sin(abs(shading.w*time)*.4f);
	float ry = cos(abs(shading.w*time)*.4f);
	float2x2 matTex = {ry, -rx,
					   rx, ry};

	ipos.xz = mul(ipos.xz, matTex);
	//otex *= .5f;
	//otex -= .5f;
	
	float global_scale = max(ROCKET[15]*(abs(shading.z))-abs(shading.x)*.8, 0.f);
	ipos.xz *= (1.+(world.w+1))*global_scale;    

	//position   +  velocity*time
	float xpos = (world.x*.8) + abs(world.x)*ROCKET[8]*(time) + world.x*ROCKET[13];//6.f*(time);//*world.x) - 30.f;
	
	
	float spread = ROCKET[12];
	ipos.x += spread*(xpos - floor(xpos))-spread/2;
	
	ipos.y +=  20.f + (abs(30.f*world.z))*ROCKET[14];
	ipos.z += (world.y*50.f);
	
//serise ting
	opos = mul(ipos, matWorldViewProjection);
	opos.x -= texelsize.x/2.f;
	opos.y -= texelsize.y/2.f;

	float FarClip = 30.0f;
	gradient.z = (opos.z/FarClip); 
		
	//propager ubrukte parametre
  	look.w = 1.f;	
	
}

float4 ps_instance_pattern(in float4 tex : TEXCOORD0,
						   in float3 gradient : TEXCOORD1)  : COLOR0
{
	tex.xy = (1-tex.xy)*2.f; //f koordsa fra -1 til 1
	
	//return float4(0, tex.y, 0.f, 0.f);
	
	
	float len = length(1-tex.xy) ; //yo!
	float pitch = 50.f*sin(len*3.145*tex.z+(time*tex.z*.3f));
	float4 p =  (saturate(pitch)*.75)*gradient.x*gradient.y*(gradient.z+ROCKET[7]); 
	return float4(p.rgb, gradient.z);
}

///////////////////////////////////////////////////////////////////////////////////


float Eksponent = .8;
float FarClip = 2.f;
float FallOff = 2.f;

float dof(float in_depth)
{
	float Focus = ROCKET[11];
	return min(1, pow(abs(in_depth-Focus)*FallOff, Eksponent));
};

sampler2D blur = sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressU = Clamp; AddressV = Clamp;
};

void vs_blit(in float4 ipos : POSITION,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	opos.x -= texelsize.x/2.f;
	opos.y -= texelsize.y/2.f;
	otex = itex;
	otex.y = 1.f-otex.y;
	otex.x = 1.f-otex.x;
};

float4 ps_composition(in float2 tex : TEXCOORD0) : COLOR0
{
	//return tex2D(blur, tex).a;
	//return float4(1.f, 0.f, 0.f, 0.f);
	float4 color_base = tex2D(blur, tex);
	
	float dof_coef = dof(color_base.a);
	
	float4 color = 0 ;
	float fake_ao = 0;
	int blur_samples = 8.f;
	float kernel_size = 1.6f*pow(ROCKET[10]/2.5, 2.7);
	
	for (int i=0; i<blur_samples; i++)    
	{
		float4 c = tex2Dlod(blur, float4(tex.xy+kernel_size*float2(sin(i*2.4), cos(i*2.4))*texelsize, 0.f, min(ROCKET[10]*i/7, 3.5f)));
		//float4 c = tex2D(blur, float2(tex.xy+kernel_size* float2(sin(i*6.4), cos(i*2.4)) *texelsize ));
		
		if( color_base.a-c.a>-0.0f )
			fake_ao = saturate(max(abs(color_base.a-c.a), fake_ao))+fake_ao;
			 
		color += c/blur_samples; 
	}
	
	//return color; 
	//return (1-fake_ao*.07);
	return lerp(color_base, color, dof_coef)*(1-fake_ao*.02)*(1+ROCKET[1]);
	return color*(1-fake_ao*.85f); 
	
}

/////////////////////////////////////////////////////////////////////////////////////

technique MongoShpa
{
	pass paint
	{
		vertexshader  = compile vs_2_0 vs_prop();
		pixelshader   = compile ps_2_0 ps_color();
	}	
	
	pass obj
	{
		vertexshader = compile vs_2_0 vs_prop();
		pixelshader  = compile ps_2_0 ps_paint_pattern();
	}
	
	pass instance_pattern
	{
		vertexshader = compile vs_2_0 vs_instance();
		pixelshader  = compile ps_2_0 ps_instance_pattern();
	}
	
	pass composition
	{
		vertexshader = compile vs_3_0 vs_blit();
		pixelshader  = compile ps_3_0 ps_composition();
	}
}

